//----------------------------------------------------------------------------//
//- CabDmo.pas ---------------------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// CabDmo kapselt alle Datenbanktabellen                                      //
//----------------------------------------------------------------------------//

unit CabDmo;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  SysUtils, Classes, DB, DBTables;

//------------------------------------------------------------------------------

type
  TCaObDatenModul = class(TDataModule)
    m_TblPersonen      : TTable;
    m_TblAnbieter      : TTable;
    m_TblArtikel       : TTable;
    m_TblBoersenInfo   : TTable;
    m_QryQuery1        : TQuery;

    //--------------------------------------------------------------------------

    procedure DataModuleCreate(Sender: TObject);

  //----------------------------------------------------------------------------

  private
    function  PrvCreateTblPersonen    : Boolean;
    function  PrvCreateTblAnbieter    : Boolean;
    function  PrvCreateTblArtikel     : Boolean;
    function  PrvCreateTblBoersenInfo : Boolean;
    procedure PrvCreateDbDir;

  //----------------------------------------------------------------------------

  public


  //----------------------------------------------------------------------------

  end; // TobDatenModul

//------------------------------------------------------------------------------

var
  CaObDatenModul: TCaObDatenModul;

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

{$R *.dfm}

//------------------------------------------------------------------------------

uses
  CamConst, Dialogs;

//------------------------------------------------------------------------------

function TCaObDatenModul.PrvCreateTblPersonen: Boolean;
(*
  Erzeugt die Tabelle 'Beratung'
*)
begin
  Result := True;
  with m_TblPersonen do begin
    // Datenbankfelder erzeugen
    with FieldDefs do begin
      Clear;
      Add(c_sPersonenPersonenNummer,         ftInteger, 0,                  True);
      Add(c_sPersonenInitialen,              ftString,  c_iMaxStringLaenge, True);
      Add(c_sPersonenName,                   ftString,  c_iMaxStringLaenge, False);
      Add(c_sPersonenVorname,                ftString,  c_iMaxStringLaenge, False);
      Add(c_sPersonenStrasse,                ftString,  c_iMaxStringLaenge, False);
      Add(c_sPersonenPlz,                    ftString,  c_iMaxStringLaenge, False);
      Add(c_sPersonenOrt,                    ftString,  c_iMaxStringLaenge, False);
    end; // with

    // Primrschlssel erstellen
    with IndexDefs do begin
      Clear;
      Add('', c_sPersonenPersonenNummer, [ixPrimary, ixUnique]);
    end; // with

    // Tabelle erzeugen
    try
      CreateTable;
    except
      // Konnte die Tabelle nicht erzeugt werden, wird False zurckgegeben
      Result := False;
    end; // try
  end; // with
end;  // TCaObDatenModul.PrvCreateTblPersonen

//------------------------------------------------------------------------------

function TCaObDatenModul.PrvCreateTblAnbieter: Boolean;
(*
  Erzeugt die Tabelle 'Anbieter'
*)
begin
  Result := True;
  with m_TblAnbieter do begin
    // Datenbankfelder erzeugen
    with FieldDefs do begin
      Clear;
      Add(c_sAnbieterArtikelNummer,  ftInteger, 0, True);
      Add(c_sAnbieterPersonenNummer, ftInteger, 0, True);
    end; // with

    // Tabelle erzeugen
    try
      CreateTable;
    except
      // Konnte die Tabelle nicht erzeugt werden, wird False zurckgegeben
      Result := False;
    end; // try
  end; // with
end;  // TCaObDatenModul.PrvCreateTblAnbieter

//------------------------------------------------------------------------------

function TCaObDatenModul.PrvCreateTblArtikel: Boolean;
(*
  Erzeugt die Tabelle 'Artikel'
*)
begin
  Result := True;
  with m_TblArtikel do begin

    // Datenbankfelder erzeugen
    with FieldDefs do begin
      Clear;
      Add(c_sArtikelArtikelNummer,   ftAutoInc, 0,                  True);
      Add(c_sArtikelBeschreibung,    ftString,  c_iMaxStringLaenge, True);
      Add(c_sArtikelBoersenNummer,   ftInteger, 0,                  True);
      Add(c_sArtikelPreis,           ftFloat,   0,                  True);
      Add(c_sArtikelVerkauft,        ftBoolean, 0,                  True);
    end; // with

    // Primrschlssel erstellen
    with IndexDefs do begin
      Clear;
      Add('', c_sArtikelArtikelNummer, [ixPrimary, ixUnique]);
    end; // with

    // Tabelle erzeugen
    try
      CreateTable;
    except
      // Konnte die Tabelle nicht erzeugt werden, wird False zurckgegeben
      Result := False;
    end; // try
  end; // with
end;  // TCaObDatenModul.PrvCreateTblArtikel

//------------------------------------------------------------------------------

function TCaObDatenModul.PrvCreateTblBoersenInfo: Boolean;
(*
  Erzeugt die Tabelle 'BoersenInfo'
*)
begin
  Result := True;
  with m_TblBoersenInfo do begin

    // Datenbankfelder erzeugen
    with FieldDefs do begin
      Clear;
      Add(c_sBoersenBoersenNummer,   ftAutoInc, 0,                  True);
      Add(c_sBoersenTitel,           ftString,  c_iMaxStringLaenge, False);
      Add(c_sBoersenAbgabeBetrag,    ftFloat,   0,                  False);
      Add(c_sBoersenAbgabeProzent,   ftFloat,   0,                  False);
      Add(c_sBoersenBoersenDatum,    ftDate,    0,                  True);
      Add(c_sBoersenAbschlussDatum,  ftDate,    0,                  True);
      Add(c_sBoerseActive,           ftBoolean, 0,                  False);
    end; // with

    // Primrschlssel erstellen
    with IndexDefs do begin
      Clear;
      Add('', c_sBoersenBoersenNummer, [ixPrimary, ixUnique]);
    end; // with

    // Tabelle erzeugen
    try
      CreateTable;
    except
      // Konnte die Tabelle nicht erzeugt werden, wird False zurckgegeben
      Result := False;
    end; // try
  end; // with
end;  // TCaObDatenModul.PrvCreateTblBoersenInfo

//------------------------------------------------------------------------------


procedure TCaObDatenModul.DataModuleCreate(Sender: TObject);
begin
  // Anlegen des Datenbankpfades
  PrvCreateDbDir;

  // Allen Tabellen Name und Pfad zuweisen
  m_TblPersonen.DatabaseName               := c_sDBPfad;
  m_TblPersonen.TableName                  := c_sDbPersonen;

  m_TblAnbieter.DataBaseName              := c_sDBPfad;
  m_TblAnbieter.TableName                 := c_sDbAnbieter;

  m_TblArtikel.DataBaseName               := c_sDBPfad;
  m_TblArtikel.TableName                  := c_sDbArtikel;

  m_TblBoersenInfo.DataBaseName           := c_sDBPfad;
  m_TblBoersenInfo.TableName              := c_sDbBoersenInfo;

  // Wenn sie noch nicht existieren, werden hier alle Tabellen der DB angelegt
  if not FileExists(IncludeTrailingPathDelimiter(c_sDbPfad) + c_sDbPersonen) then begin
    PrvCreateTblPersonen;
  end; // if
  if not FileExists(IncludeTrailingPathDelimiter(c_sDbPfad) + c_sDbAnbieter) then begin
    PrvCreateTblAnbieter;
  end; // if
  if not FileExists(IncludeTrailingPathDelimiter(c_sDbPfad) + c_sDbArtikel) then begin
    PrvCreateTblArtikel;
  end; // if
  if not FileExists(IncludeTrailingPathDelimiter(c_sDbPfad) + c_sDbBoersenInfo) then begin
    PrvCreateTblBoersenInfo;
  end; // if
end; // TCaObDatenModul.DataModuleCreate

//------------------------------------------------------------------------------

procedure TCaObDatenModul.PrvCreateDbDir;
begin
  if not DirectoryExists(c_sDbPfad) then begin
    {$I-}
    // Anlegen des DB-Pfades
    mkDir(c_sDbPfad);
    // Konnte der Pfad nicht angelegt werden, wird eine Fehlermeldung ausgegeben
    if ioResult <> 0 then begin
      ShowMessage(c_sMeldungDatenbankpfadFehler);
    end; // if
    {$I+}
  end; // if
end; // TCaObDatenModul.PrvCreateDbDir

//------------------------------------------------------------------------------

end. // CabDmo
